IF  EXISTS (SELECT 1 FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[V_EST_PROD_TBL_DESC_QTDE_TIPOS]'))
DROP VIEW [dbo].[V_EST_PROD_TBL_DESC_QTDE_TIPOS]
GO
--SELECT * FROM V_EST_PROD_TBL_DESC_QTDE_TIPOS
CREATE VIEW V_EST_PROD_TBL_DESC_QTDE_TIPOS AS 
SELECT
	TB.CD_EMP,
	F.CD_FILIAL,
	TB.CD_TBL_DESC_QTDE,
	TB.DS_TBL_DESC_QTDE,
	TB.DT_INI,
	TB.DT_FIM,
	TB.CD_TP_DESCONTO,
	G.DS_TP_DESCONTO,
	TB.CD_USU,
	TB.DT_CAD,
	TB.DT_ULT_ALT,
	TB.STS_TBL_DESC,
	TB.ST_PRORROG,
	TB.CD_PROD,
	TB.DS_HIERARQUIA,
	TB.PERC_DESC,
	TB.PERC_DESC_MAX,
	TB.SOBREPOR_OFERTA,
	TB.PRECO_ESPECIFICO,
	TB.TP_DESCONTO,
	TB.FLAG_ENVIO_PROPZ,
	TB.FLAG_TP_DESCONTO_PROPZ
FROM
	(
	SELECT
		D.CD_EMP,
		D.CD_TBL_DESC_QTDE,
		D.DS_TBL_DESC_QTDE,
		D.DT_INI,
		D.DT_FIM,
		D.CD_TP_DESCONTO,
		D.CD_USU,
		D.DT_CAD,
		D.DT_ULT_ALT,
		D.STS_TBL_DESC,
		D.ST_PRORROG,
		A.CD_PROD,
		'LINHA' AS DS_HIERARQUIA,
		((1-(D.QTDE_PAGUE / CONVERT(MONEY,
		D.QTDE_LEVE)))* 100.) PERC_DESC,
		((1-(D.QTDE_PAGUE / CONVERT(MONEY,
		D.QTDE_LEVE)))* 100.) PERC_DESC_MAX,
		0 AS SOBREPOR_OFERTA,
		0 AS PRECO_ESPECIFICO,
		2 AS TP_DESCONTO,
		D.FLAG_ENVIO_PROPZ,
		D.FLAG_TP_DESCONTO_PROPZ
	FROM
		EST_PROD_TBL_DESC_QTDE D
	INNER JOIN EST_PROD_TBL_DESC_QTDE_EST_ARV_MERC_LINHA L ON
		D.CD_EMP = L.CD_EMP
		AND D.CD_TBL_DESC_QTDE = L.CD_TBL_DESC_QTDE
	INNER JOIN EST_PROD_EST_ARV_MERCADOLOGICA A ON
		L.CD_EMP = A.CD_EMP
		AND L.CD_ARV_MERC_LINHA = A.CD_ARV_MERC_LINHA
	
	UNION ALL
	
	SELECT
		D.CD_EMP,
		D.CD_TBL_DESC_QTDE,
		D.DS_TBL_DESC_QTDE,
		D.DT_INI,
		D.DT_FIM,
		D.CD_TP_DESCONTO,
		D.CD_USU,
		D.DT_CAD,
		D.DT_ULT_ALT,
		D.STS_TBL_DESC,
		D.ST_PRORROG,
		A.CD_PROD,
		'CATEGORIA' AS DS_HIERARQUIA,
		((1-(D.QTDE_PAGUE / CONVERT(MONEY,
		D.QTDE_LEVE)))* 100.) PERC_DESC,
		((1-(D.QTDE_PAGUE / CONVERT(MONEY,
		D.QTDE_LEVE)))* 100.) PERC_DESC_MAX,
		0 AS SOBREPOR_OFERTA,
		0 AS PRECO_ESPECIFICO,
		2 AS TP_DESCONTO,
		D.FLAG_ENVIO_PROPZ,
		D.FLAG_TP_DESCONTO_PROPZ
	FROM
		EST_PROD_TBL_DESC_QTDE D
	INNER JOIN EST_PROD_TBL_DESC_QTDE_EST_ARV_MERC_CATEGORIA C ON
		D.CD_EMP = C.CD_EMP
		AND D.CD_TBL_DESC_QTDE = C.CD_TBL_DESC_QTDE
	INNER JOIN EST_PROD_EST_ARV_MERCADOLOGICA A ON
		C.CD_EMP = A.CD_EMP
		AND C.CD_ARV_MERC_CATEG = A.CD_ARV_MERC_CATEG
		
	UNION ALL
	
	SELECT
		D.CD_EMP,
		D.CD_TBL_DESC_QTDE,
		D.DS_TBL_DESC_QTDE,
		D.DT_INI,
		D.DT_FIM,
		D.CD_TP_DESCONTO,
		D.CD_USU,
		D.DT_CAD,
		D.DT_ULT_ALT,
		D.STS_TBL_DESC,
		D.ST_PRORROG,
		P.CD_PROD,
		'FABRICANTE' AS DS_HIERARQUIA,
		((1-(D.QTDE_PAGUE / CONVERT(MONEY,
		D.QTDE_LEVE)))* 100.) PERC_DESC,
		((1-(D.QTDE_PAGUE / CONVERT(MONEY,
		D.QTDE_LEVE)))* 100.) PERC_DESC_MAX,
		0 AS SOBREPOR_OFERTA,
		0 AS PRECO_ESPECIFICO,
		2 AS TP_DESCONTO,
		D.FLAG_ENVIO_PROPZ,
		D.FLAG_TP_DESCONTO_PROPZ
	FROM
		EST_PROD_TBL_DESC_QTDE D
	INNER JOIN EST_PROD_TBL_DESC_QTDE_EST_PROD_FABRIC F ON
		D.CD_EMP = F.CD_EMP
		AND D.CD_TBL_DESC_QTDE = F.CD_TBL_DESC_QTDE
	INNER JOIN EST_PROD P ON
		F.CD_EMP = P.CD_EMP
		AND F.CD_FABRIC = P.CD_FABRIC
	
	UNION ALL
	
	SELECT
		D.CD_EMP,
		D.CD_TBL_DESC_QTDE,
		D.DS_TBL_DESC_QTDE,
		D.DT_INI,
		D.DT_FIM,
		D.CD_TP_DESCONTO,
		D.CD_USU,
		D.DT_CAD,
		D.DT_ULT_ALT,
		D.STS_TBL_DESC,
		D.ST_PRORROG,
		P.CD_PROD,
		'MARCA' AS DS_HIERARQUIA,
		((1-(D.QTDE_PAGUE / CONVERT(MONEY,
		D.QTDE_LEVE)))* 100.) PERC_DESC,
		((1-(D.QTDE_PAGUE / CONVERT(MONEY,
		D.QTDE_LEVE)))* 100.) PERC_DESC_MAX,
		0 AS SOBREPOR_OFERTA,
		0 AS PRECO_ESPECIFICO,
		2 AS TP_DESCONTO,
		D.FLAG_ENVIO_PROPZ,
		D.FLAG_TP_DESCONTO_PROPZ
	FROM
		EST_PROD_TBL_DESC_QTDE D
	INNER JOIN EST_PROD_TBL_DESC_QTDE_EST_MC M ON
		D.CD_EMP = M.CD_EMP
		AND D.CD_TBL_DESC_QTDE = M.CD_TBL_DESC_QTDE
	INNER JOIN EST_PROD P ON
		M.CD_EMP = P.CD_EMP
		AND M.CD_MC = P.CD_MC

	UNION ALL
	
	SELECT
		D.CD_EMP,
		D.CD_TBL_DESC_QTDE,
		D.DS_TBL_DESC_QTDE,
		D.DT_INI,
		D.DT_FIM,
		D.CD_TP_DESCONTO,
		D.CD_USU,
		D.DT_CAD,
		D.DT_ULT_ALT,
		D.STS_TBL_DESC,
		D.ST_PRORROG,
		A.CD_PROD,
		'FAMILIA' AS DS_HIERARQUIA,
		((1-(D.QTDE_PAGUE / CONVERT(MONEY,
		D.QTDE_LEVE)))* 100.) PERC_DESC,
		((1-(D.QTDE_PAGUE / CONVERT(MONEY,
		D.QTDE_LEVE)))* 100.) PERC_DESC_MAX,
		0 AS SOBREPOR_OFERTA,
		0 AS PRECO_ESPECIFICO,
		2 AS TP_DESCONTO,
		D.FLAG_ENVIO_PROPZ,
		D.FLAG_TP_DESCONTO_PROPZ
	FROM
		EST_PROD_TBL_DESC_QTDE D
	INNER JOIN EST_PROD_TBL_DESC_QTDE_EST_ARV_MERC_FAMILIA E ON
		D.CD_EMP = E.CD_EMP
		AND D.CD_TBL_DESC_QTDE = E.CD_TBL_DESC_QTDE
	INNER JOIN EST_PROD_EST_ARV_MERCADOLOGICA A ON
		E.CD_EMP = A.CD_EMP
		AND E.CD_ARV_MERC_FAMILIA = A.CD_ARV_MERC_FAMILIA

	UNION ALL
	
	SELECT
		D.CD_EMP,
		D.CD_TBL_DESC_QTDE,
		D.DS_TBL_DESC_QTDE,
		D.DT_INI,
		D.DT_FIM,
		D.CD_TP_DESCONTO,
		D.CD_USU,
		D.DT_CAD,
		D.DT_ULT_ALT,
		D.STS_TBL_DESC,
		D.ST_PRORROG,
		T.CD_PROD,
		'PRODUTO' AS DS_HIERARQUIA,
		((1-(D.QTDE_PAGUE / CONVERT(MONEY,
		D.QTDE_LEVE)))* 100.) PERC_DESC,
		((1-(D.QTDE_PAGUE / CONVERT(MONEY,
		D.QTDE_LEVE)))* 100.) PERC_DESC_MAX,
		0 AS SOBREPOR_OFERTA,
		0 AS PRECO_ESPECIFICO,
		2 AS TP_DESCONTO,
		D.FLAG_ENVIO_PROPZ,
		D.FLAG_TP_DESCONTO_PROPZ
	FROM
		EST_PROD_TBL_DESC_QTDE D
	INNER JOIN EST_PROD_TBL_DESC_QTDE_EST_PROD T ON
		D.CD_EMP = T.CD_EMP
		AND D.CD_TBL_DESC_QTDE = T.CD_TBL_DESC_QTDE											
) TB
INNER JOIN EST_PROD_TBL_DESC_QTDE_PRC_FILIAL F ON
	TB.CD_EMP = F.CD_EMP
	AND
	TB.CD_TBL_DESC_QTDE = F.CD_TBL_DESC_QTDE
INNER JOIN GLB_TP_DESCONTO G ON
	TB.CD_TP_DESCONTO = G.CD_TP_DESCONTO
	
UNION ALL												

SELECT       
	EST_PROD_PRECO_DESC_QTDE_CPL.CD_EMP,
	EST_PROD_PRECO_DESC_QTDE_PRC_FILIAL.CD_FILIAL,
	EST_PROD_PRECO_DESC_QTDE.CD_PRECO_DESC_QTDE, 
	EST_PROD_PRECO_DESC_QTDE.NM_PROMOCAO, 
	EST_PROD_PRECO_DESC_QTDE.DT_INICIAL, 
	EST_PROD_PRECO_DESC_QTDE.DT_FINAL, 
	14 AS CD_TP_DESCONTO,
	'DESCONTO QUANTIDADE ANTIGO' AS DS_TP_DESCONTO,
	EST_PROD_PRECO_DESC_QTDE.CD_USU, 
	EST_PROD_PRECO_DESC_QTDE.DT_CAD, 
	EST_PROD_PRECO_DESC_QTDE.DT_ULT_ALT, 
	1 AS STS_TBL_DESC,
	0 AS ST_PRORROG,
	EST_PROD_PRECO_DESC_QTDE_CPL.CD_PROD,
	'MODELO ANTIGO' AS DS_HIERARQUIA,
	EST_PROD_PRECO_DESC_QTDE.PERC_DESC,
	0 AS PERC_DESC_MAX,
	0 AS SOBREPOR_OFERTA,
	0 AS PRECO_ESPECIFICO,
	1 AS TP_DESCONTO,
	0 AS FLAG_ENVIO_PROPZ,
	0 AS FLAG_TP_DESCONTO_PROPZ
FROM            
	EST_PROD_PRECO_DESC_QTDE
INNER JOIN EST_PROD_PRECO_DESC_QTDE_CPL ON 
	EST_PROD_PRECO_DESC_QTDE.CD_PRECO_DESC_QTDE = EST_PROD_PRECO_DESC_QTDE_CPL.CD_PRECO_DESC_QTDE
INNER JOIN EST_PROD_PRECO_DESC_QTDE_PRC_FILIAL ON
	EST_PROD_PRECO_DESC_QTDE.CD_PRECO_DESC_QTDE = EST_PROD_PRECO_DESC_QTDE_PRC_FILIAL.CD_PRECO_DESC_QTDE
